//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================
using Microsoft.Practices.EnterpriseLibrary.Configuration.Factory;
namespace Microsoft.Practices.EnterpriseLibrary.Configuration.Injection
{
	/// <summary>
	/// Represents a simple strategy that returns the source value as the transformed value.
	/// </summary>
    public class NullFactory<TObjectToCreate, TObjectConfiguration> : ObjectFactoryBase<TObjectToCreate, TObjectConfiguration>
	{
		/// <summary>
        /// Initialize a new instance of the <see cref="NullFactory"/> class.
		/// </summary>
        public NullFactory()
		{
		}

        public override TObjectToCreate Create(TObjectConfiguration objectConfiguration, IConfigurationSource configurationSource)
        {
            return (TObjectToCreate)(object)objectConfiguration;
        }
    }
}
